#ifndef __ICMPHEADER_H_
#define __ICMPHEADER_H_

#include "utils.h"

#pragma pack(push, 1)
struct _icmp_header
{
  u_char  type;
  u_char  code;
  u_short checksum;
  u_short identifier;
  u_short sequence_number;			
};
#pragma pack(pop)

#define ICMP_HEADER_SIZE sizeof(_icmp_header)
#define ICMP_ECHO_TYPE 8
#define ICMP_ECHO_REPLY_TYPE 0

class ICMPHeader
{
public:

  ICMPHeader(u_char _type, u_short _identifier, u_short _seqnumber, u_char *_data, u_short _size);
  ICMPHeader(const u_char *_data, long _size);
  void dump();
  u_short compute_checksum();
  void setMem(u_char *_data);
  u_char  type() const;
  u_char  code() const;
  u_short  checksum();
  u_short  identifier();
  u_short  sequence_number();
private:
  _icmp_header header;

  const u_char *data;
  long size;
  u_short computed_checksum;

  void data2host(void);
  void data2network(void);
};

#endif
